/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskUSMUdevChecks;
import oracle.ops.verification.framework.engine.task.TaskVotingDisk;
import oracle.ops.verification.framework.util.VerificationUtil;

public class VDiskComponent
extends Component {
    VDiskComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
    }

    @Override
    public boolean verify() {
        boolean retval = this.checkSetup();
        retval = this.validateEnvironment();
        if (!retval) {
            return false;
        }
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        switch (this.m_verificationType) {
            case 25: {
                TaskVotingDisk taskVoteDsk = new TaskVotingDisk(validNodeArr);
                retval &= taskVoteDsk.perform();
                Trace.out((String)"\n>>>> VDiskComponent:: Upload taskVoteDsk >>>>>\n");
                this.m_resultSet.uploadResultSet(taskVoteDsk.getResultSet());
                if (VerificationUtil.isUDEVSupported()) {
                    TaskUSMUdevChecks taskUDev = new TaskUSMUdevChecks(validNodeArr);
                    taskUDev.setVDiskUDevCheck();
                    retval &= taskUDev.perform();
                    Trace.out((String)"\n>>>> VDiskComponent:: Upload taskUDev >>>>>\n");
                    this.m_resultSet.uploadResultSet(taskUDev.getResultSet());
                }
                return retval;
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "VOTING_DISK";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9970", false);
    }
}

